#pragma once

#include <stdint.h>
#include <math.h>

#include <QString>

class resolution
{
public: int width;
        int height;

        resolution()
        {
            width = 360;
            height = 240;

            recalculate();
        }

        resolution(int w,int h)
        {
            width = w;
            height = h;

            recalculate();
        }

        QString whToString()
        {
            return QString("%1x%2").arg(width).arg(height);
        }

        //

        float FOV;
        float near;
        float far;
        float foscale;

        float top;
        float bottom;

        float right;
        float left;

private:
            void recalculate()
            {
                //

                float pi = 3.141592741012573242187;
                FOV = 60.0f;
                near = 0.1f;
                far = 60.0f;
                foscale = (float)(tan((FOV * (pi / 180.0f)) / 2.0f)) * near;

                top = foscale;
                bottom = -top;

                right = foscale * (((float)width) / ((float)height));
                left = -right;
            }

};
