#include "platformdialog.h"
#include "ui_platformdialog.h"

/**
 * @brief PlatformDialog::PlatformDialog
 * @param parent
 */

PlatformDialog::PlatformDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::PlatformDialog)
{
    ui->setupUi(this);
}

/**
 * @brief PlatformDialog::~PlatformDialog
 */

PlatformDialog::~PlatformDialog()
{
    delete ui;
}

/**
 * @brief PlatformDialog::addPlatform
 * @param name
 */

void PlatformDialog::addPlatform(QString name)
{
    ui->comboBoxPlatform->addItem(name);
}

/**
 * @brief PlatformDialog::useCpu
 * @return
 */

bool PlatformDialog::useCpu()
{
    return ui->checkBoxUseCpu->isChecked();
}

/**
 * @brief PlatformDialog::saveTemps
 * @return
 */

bool PlatformDialog::saveTemps()
{
    return ui->checkBoxSaveTemps->isChecked();
}

/**
 * @brief PlatformDialog::currentPlatform
 * @return
 */

QString PlatformDialog::currentPlatform()
{
    return ui->comboBoxPlatform->currentText();
}

/**
 * @brief PlatformDialog::wError
 * @return
 */

bool PlatformDialog::wError()
{
    return ui->checkBoxWerror->isChecked();
}

/**
 * @brief PlatformDialog::fastMath
 * @return
 */

bool PlatformDialog::fastMath()
{
    return ui->checkBoxFastMath->isChecked();
}

