#pragma once

#include <QMainWindow>
#include <QTimer>
#include <QList>
#include <QMap>

#include "displaywidget.hpp"
#include "clworker.h"

namespace Ui {
class MainWindow;
}

class clProgram
{
public: clProgram(QString name,QString infoText="") {m_name = name;m_infoText = infoText;}
        clProgram() {}
            QString getName() { return m_name; }
            QString getInfoText() { return m_infoText; }
            void add(clKernelConfig kc) {m_kernelConfigs.append(kc);}
            QList<clKernelConfig> &getAll() { return m_kernelConfigs;}

    private:
    QString m_name;
    QString m_infoText;
    QList<clKernelConfig> m_kernelConfigs;
};

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

protected:
    bool eventFilter(QObject *obj, QEvent *event);
    void printProgrammInfo();

public slots:

    void draw();
    void kernelIndexChanged(int);

private:
    QMap<QString,clProgram> m_programs;
    Ui::MainWindow *ui;
    displayWidget *m_dw;
    QTimer *m_timer;
    clWorker *m_clWorker;
};
