#include "displaywidget.hpp"

#include <QString>
#include <QFontMetrics>

/**
 * @brief displayWidget::displayWidget
 * @param parent
 */

displayWidget::displayWidget(QWidget *parent,resolution resolution) : QWidget(parent)
{
    m_pixel = NULL;
    setResolution(resolution);
}

/**
 * @brief displayWidget::~displayWidget
 */

displayWidget::~displayWidget()
{
    if(m_pixel)
    {
        delete[] m_pixel;
    }
}

/**
 * @brief displayWidget::setResolution
 * @param res
 */

void displayWidget::setResolution(resolution res)
{
    if(m_pixel)
    {
        delete[] m_pixel;
    }

    m_resolution = res;
    m_pixel = new uint32_t[res.width * res.height];
    if(m_pixel)
    {
        for(int i=0,length = res.width * res.height;i<length;i++)
        {
            m_pixel[i] = 0xff000000UL;
        }
    }
}

/**
 * @brief displayWidget::getResolution
 * @return
 */

resolution displayWidget::getResolution()
{
    return m_resolution;
}

/**
 * @brief getPixels
 * @return
 */

uint32_t* displayWidget::getPixels()
{
    return m_pixel;
}

/**
 * @brief displayWidget::paintEvent
 */

void displayWidget::paintEvent(QPaintEvent *)
{
    QPainter painter(this);
    if(m_pixel)
    {
        m_image = QImage((uchar*)m_pixel,m_resolution.width,m_resolution.height,QImage::Format_ARGB32);
        painter.drawImage(QRect(0,0,this->width(),this->height()),m_image,QRect(0,0,m_resolution.width,m_resolution.height),Qt::NoFormatConversion);
    }
}
